/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.PropertyChangeDiff;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.ErrorBarType;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;

public class PlotElementStyle
extends DomNode {
    private double symbolSize = 1.0;
    public static final String PROP_SYMBOL_SIZE = "symbolSize";
    public static final String PROP_LINE_WIDTH = "lineWidth";
    private double lineWidth = 1.0;
    protected Color color = Color.BLACK;
    public static final String PROP_COLOR = "color";
    protected Color fillColor = Color.GRAY;
    public static final String PROP_FILLCOLOR = "fillColor";
    private String fillDirection = "both";
    public static final String PROP_FILL_DIRECTION = "fillDirection";
    private boolean drawError = false;
    public static final String PROP_DRAWERROR = "drawError";
    private ErrorBarType errorBarType = ErrorBarType.BAR;
    public static final String PROP_ERRORBARTYPE = "errorBarType";
    public static final String PROP_COLORTABLE = "colortable";
    private DasColorBar.Type colortable = DasColorBar.Type.COLOR_WEDGE;
    public static final String PROP_PLOT_SYMBOL = "plotSymbol";
    private PlotSymbol plotSymbol = DefaultPlotSymbol.CIRCLES;
    public static final String PROP_SYMBOL_CONNECTOR = "symbolConnector";
    private PsymConnector symbolConnector = PsymConnector.NONE;
    public static final String PROP_REFERENCE = "reference";
    private Datum reference = Units.dimensionless.createDatum(0);
    public static final String PROP_FILL_TO_REFERENCE = "fillToReference";
    private boolean fillToReference = false;
    protected SpectrogramRenderer.RebinnerEnum rebinMethod = SpectrogramRenderer.RebinnerEnum.binAverage;
    public static final String PROP_REBINMETHOD = "rebinMethod";
    protected boolean antiAliased = true;
    public static final String PROP_ANTIALIASED = "antiAliased";
    private boolean showLimits = true;
    public static final String PROP_SHOWLIMITS = "showLimits";

    public double getSymbolSize() {
        return this.symbolSize;
    }

    public void setSymbolSize(double symbolSize) {
        Double oldVal = this.symbolSize;
        this.symbolSize = symbolSize;
        this.propertyChangeSupport.firePropertyChange(PROP_SYMBOL_SIZE, oldVal, symbolSize);
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        Double oldVal = this.lineWidth;
        this.lineWidth = lineWidth;
        this.propertyChangeSupport.firePropertyChange(PROP_LINE_WIDTH, oldVal, lineWidth);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        Color oldColor = this.color;
        this.color = color;
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, color);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        if (fillColor == null) {
            throw new IllegalArgumentException("color is null");
        }
        Color oldFillColor = this.fillColor;
        this.fillColor = fillColor;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLCOLOR, oldFillColor, fillColor);
    }

    public String getFillDirection() {
        return this.fillDirection;
    }

    public void setFillDirection(String fillDirection) {
        String oldFillDirection = this.fillDirection;
        this.fillDirection = fillDirection;
        this.propertyChangeSupport.firePropertyChange(PROP_FILL_DIRECTION, oldFillDirection, fillDirection);
    }

    public boolean isDrawError() {
        return this.drawError;
    }

    public void setDrawError(boolean drawError) {
        boolean oldDrawError = this.drawError;
        this.drawError = drawError;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWERROR, oldDrawError, drawError);
    }

    public ErrorBarType getErrorBarType() {
        return this.errorBarType;
    }

    public void setErrorBarType(ErrorBarType errorBarType) {
        ErrorBarType oldErrorBarType = this.errorBarType;
        this.errorBarType = errorBarType;
        this.propertyChangeSupport.firePropertyChange(PROP_ERRORBARTYPE, oldErrorBarType, errorBarType);
    }

    public DasColorBar.Type getColortable() {
        return this.colortable;
    }

    public void setColortable(DasColorBar.Type colortable) {
        DasColorBar.Type oldVal = this.colortable;
        this.colortable = colortable;
        this.propertyChangeSupport.firePropertyChange(PROP_COLORTABLE, oldVal, this.colortable);
    }

    public PlotSymbol getPlotSymbol() {
        return this.plotSymbol;
    }

    public void setPlotSymbol(PlotSymbol plotSymbol) {
        PlotSymbol oldVal = this.plotSymbol;
        this.plotSymbol = plotSymbol;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_SYMBOL, oldVal, plotSymbol);
    }

    public PsymConnector getSymbolConnector() {
        return this.symbolConnector;
    }

    public void setSymbolConnector(PsymConnector symbolConnector) {
        if (symbolConnector == null) {
            throw new NullPointerException("symbolConnector is null");
        }
        PsymConnector oldVal = this.symbolConnector;
        this.symbolConnector = symbolConnector;
        this.propertyChangeSupport.firePropertyChange(PROP_SYMBOL_CONNECTOR, oldVal, symbolConnector);
    }

    public Datum getReference() {
        return this.reference;
    }

    public void setReference(Datum reference) {
        Datum oldVal = this.reference;
        this.reference = reference;
        this.propertyChangeSupport.firePropertyChange(PROP_REFERENCE, oldVal, reference);
    }

    public boolean isFillToReference() {
        return this.fillToReference;
    }

    public void setFillToReference(boolean fillToReference) {
        boolean oldVal = this.fillToReference;
        this.fillToReference = fillToReference;
        this.propertyChangeSupport.firePropertyChange(PROP_FILL_TO_REFERENCE, oldVal, fillToReference);
    }

    public SpectrogramRenderer.RebinnerEnum getRebinMethod() {
        return this.rebinMethod;
    }

    public void setRebinMethod(SpectrogramRenderer.RebinnerEnum rebinMethod) {
        SpectrogramRenderer.RebinnerEnum oldRebinMethod = this.rebinMethod;
        this.rebinMethod = rebinMethod;
        this.propertyChangeSupport.firePropertyChange(PROP_REBINMETHOD, oldRebinMethod, rebinMethod);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean oldAntiAliased = this.antiAliased;
        this.antiAliased = antiAliased;
        this.propertyChangeSupport.firePropertyChange(PROP_ANTIALIASED, oldAntiAliased, antiAliased);
    }

    public boolean isShowLimits() {
        return this.showLimits;
    }

    public void setShowLimits(boolean showLimits) {
        boolean oldShowLimits = this.showLimits;
        this.showLimits = showLimits;
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWLIMITS, oldShowLimits, showLimits);
    }

    @Override
    public void syncTo(DomNode node) {
        this.syncTo(node, new ArrayList<String>());
    }

    @Override
    public void syncTo(DomNode node, List<String> exclude) {
        super.syncTo(node, exclude);
        if (!(node instanceof PlotElementStyle)) {
            throw new IllegalArgumentException("node should be a PlotElementStyle");
        }
        PlotElementStyle that = (PlotElementStyle)node;
        if (!exclude.contains(PROP_COLORTABLE)) {
            this.setColortable(that.colortable);
        }
        if (!exclude.contains(PROP_FILL_TO_REFERENCE)) {
            this.setFillToReference(that.fillToReference);
        }
        if (!exclude.contains(PROP_FILL_DIRECTION)) {
            this.setFillDirection(that.fillDirection);
        }
        if (!exclude.contains(PROP_COLOR)) {
            this.setColor(that.getColor());
        }
        if (!exclude.contains(PROP_FILLCOLOR)) {
            this.setFillColor(that.getFillColor());
        }
        if (!exclude.contains(PROP_REFERENCE)) {
            this.setReference(that.getReference());
        }
        if (!exclude.contains(PROP_LINE_WIDTH)) {
            this.setLineWidth(that.getLineWidth());
        }
        if (!exclude.contains(PROP_PLOT_SYMBOL)) {
            this.setPlotSymbol(that.getPlotSymbol());
        }
        if (!exclude.contains(PROP_SYMBOL_SIZE)) {
            this.setSymbolSize(that.getSymbolSize());
        }
        if (!exclude.contains(PROP_SYMBOL_CONNECTOR)) {
            this.setSymbolConnector(that.getSymbolConnector());
        }
        if (!exclude.contains(PROP_REBINMETHOD)) {
            this.setRebinMethod(that.getRebinMethod());
        }
        if (!exclude.contains(PROP_SHOWLIMITS)) {
            this.setShowLimits(that.showLimits);
        }
        if (!exclude.contains(PROP_DRAWERROR)) {
            this.setDrawError(that.isDrawError());
        }
        if (!exclude.contains(PROP_ERRORBARTYPE)) {
            this.setErrorBarType(that.getErrorBarType());
        }
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        if (!(node instanceof PlotElementStyle)) {
            throw new IllegalArgumentException("node should be a PlotElementStyle");
        }
        PlotElementStyle that = (PlotElementStyle)node;
        List<Diff> result = super.diffs(node);
        boolean b = that.color.equals(this.color);
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_COLOR, that.color, this.color));
        }
        if (!(b = that.fillColor.equals(this.fillColor))) {
            result.add(new PropertyChangeDiff(PROP_FILLCOLOR, that.fillColor, this.fillColor));
        }
        if (!(b = that.fillDirection.equals(this.fillDirection))) {
            result.add(new PropertyChangeDiff(PROP_FILL_DIRECTION, that.fillDirection, this.fillDirection));
        }
        if (!(b = that.colortable.equals(this.colortable))) {
            result.add(new PropertyChangeDiff(PROP_COLORTABLE, that.colortable, this.colortable));
        }
        boolean bl = b = that.lineWidth == this.lineWidth;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_LINE_WIDTH, that.lineWidth, this.lineWidth));
        }
        boolean bl2 = b = that.symbolSize == this.symbolSize;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_SYMBOL_SIZE, that.symbolSize, this.symbolSize));
        }
        if (!(b = that.plotSymbol.equals(this.plotSymbol))) {
            result.add(new PropertyChangeDiff(PROP_PLOT_SYMBOL, that.plotSymbol, this.plotSymbol));
        }
        if (!(b = that.symbolConnector.equals(this.symbolConnector))) {
            result.add(new PropertyChangeDiff(PROP_SYMBOL_CONNECTOR, that.symbolConnector, this.symbolConnector));
        }
        boolean bl3 = b = that.fillToReference == this.fillToReference;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_FILL_TO_REFERENCE, that.fillToReference, this.fillToReference));
        }
        boolean bl4 = b = that.rebinMethod == this.rebinMethod;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_REBINMETHOD, that.rebinMethod, this.rebinMethod));
        }
        if (!(b = that.reference.equals(this.reference))) {
            result.add(new PropertyChangeDiff(PROP_REFERENCE, that.reference, this.reference));
        }
        boolean bl5 = b = that.showLimits == this.showLimits;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_SHOWLIMITS, that.showLimits, this.showLimits));
        }
        boolean bl6 = b = that.drawError == this.drawError;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_DRAWERROR, that.drawError, this.drawError));
        }
        if (!(b = that.errorBarType.equals((Object)this.errorBarType))) {
            result.add(new PropertyChangeDiff(PROP_ERRORBARTYPE, that.errorBarType, this.errorBarType));
        }
        return result;
    }
}

